package gov.va.med.mhv.getcare.repository;

import gov.va.med.mhv.getcare.model.HealthCareProvider;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface HealthCareProviderRepository extends JpaRepository<HealthCareProvider, Long> {

	@Query("select h from HealthCareProvider h where h.userProfileId = :userProfileId order by UPPER(h.providerType) asc")
	public List<HealthCareProvider> findProvidersForUser(@Param("userProfileId") Long userProfileId);
	
	@Query("select h from HealthCareProvider h where h.userProfileId = :userProfileId order by UPPER(h.providerType) asc")
	public List<HealthCareProvider> findDashboardProvidersForUser(@Param("userProfileId") Long userProfileId,Pageable page);
		
	@Query("select h from HealthCareProvider h where h.healthCareProviderId = :healthCareProviderId")
	public HealthCareProvider findByHealthCareProviderId(@Param("healthCareProviderId") Long healthCareProviderId);
	
	@Query("select h from HealthCareProvider h where h.userProfileId = :userProfileId and h.providerType = 'P'")
	public List<HealthCareProvider> findPrimaryHealthCareProvider(@Param("userProfileId") Long userProfileId);
}